<?php
session_start();

require_once '../config/db.php';
require_once 'auth.php';
requireAdminLogin();

$admin = getCurrentAdmin();
$message = '';
$message_type = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $db = getDB();
    
    if (isset($_POST['logout'])) {
        adminLogout();
    }
    
    if (isset($_POST['save_general_settings'])) {
        try {
            $settings = [
                'site_name' => sanitizeInput($_POST['site_name'] ?? ''),
                'site_tagline' => sanitizeInput($_POST['site_tagline'] ?? ''),
                'business_name' => sanitizeInput($_POST['business_name'] ?? ''),
                'business_description' => sanitizeInput($_POST['business_description'] ?? ''),
                'primary_email' => sanitizeInput($_POST['primary_email'] ?? ''),
                'secondary_email' => sanitizeInput($_POST['secondary_email'] ?? ''),
                'primary_phone' => sanitizeInput($_POST['primary_phone'] ?? ''),
                'secondary_phone' => sanitizeInput($_POST['secondary_phone'] ?? ''),
                'whatsapp_number' => sanitizeInput($_POST['whatsapp_number'] ?? ''),
                'business_address' => sanitizeInput($_POST['business_address'] ?? ''),
                'city' => sanitizeInput($_POST['city'] ?? ''),
                'state' => sanitizeInput($_POST['state'] ?? ''),
                'postal_code' => sanitizeInput($_POST['postal_code'] ?? ''),
                'country' => sanitizeInput($_POST['country'] ?? ''),
                'business_hours' => sanitizeInput($_POST['business_hours'] ?? ''),
            ];
            
            foreach ($settings as $key => $value) {
                $stmt = $db->prepare("INSERT INTO business_settings (setting_key, setting_value) VALUES (?, ?) ON DUPLICATE KEY UPDATE setting_value = ?");
                $stmt->execute([$key, $value, $value]);
            }
            
            $message = 'General settings updated successfully!';
            $message_type = 'success';
        } catch (Exception $e) {
            $message = 'Error: ' . $e->getMessage();
            $message_type = 'error';
        }
    }
    
    if (isset($_POST['save_social_settings'])) {
        try {
            $social_settings = [
                'facebook_url' => sanitizeInput($_POST['facebook_url'] ?? ''),
                'instagram_url' => sanitizeInput($_POST['instagram_url'] ?? ''),
                'twitter_url' => sanitizeInput($_POST['twitter_url'] ?? ''),
                'youtube_url' => sanitizeInput($_POST['youtube_url'] ?? ''),
                'linkedin_url' => sanitizeInput($_POST['linkedin_url'] ?? ''),
                'pinterest_url' => sanitizeInput($_POST['pinterest_url'] ?? ''),
            ];
            
            foreach ($social_settings as $key => $value) {
                $stmt = $db->prepare("INSERT INTO business_settings (setting_key, setting_value) VALUES (?, ?) ON DUPLICATE KEY UPDATE setting_value = ?");
                $stmt->execute([$key, $value, $value]);
            }
            
            $message = 'Social media settings updated successfully!';
            $message_type = 'success';
        } catch (Exception $e) {
            $message = 'Error: ' . $e->getMessage();
            $message_type = 'error';
        }
    }
    
    if (isset($_POST['save_seo_settings'])) {
        try {
            $seo_settings = [
                'meta_title' => sanitizeInput($_POST['meta_title'] ?? ''),
                'meta_description' => sanitizeInput($_POST['meta_description'] ?? ''),
                'meta_keywords' => sanitizeInput($_POST['meta_keywords'] ?? ''),
                'google_analytics_id' => sanitizeInput($_POST['google_analytics_id'] ?? ''),
                'google_maps_embed' => sanitizeInput($_POST['google_maps_embed'] ?? ''),
            ];
            
            foreach ($seo_settings as $key => $value) {
                $stmt = $db->prepare("INSERT INTO business_settings (setting_key, setting_value) VALUES (?, ?) ON DUPLICATE KEY UPDATE setting_value = ?");
                $stmt->execute([$key, $value, $value]);
            }
            
            $message = 'SEO & Analytics settings updated successfully!';
            $message_type = 'success';
        } catch (Exception $e) {
            $message = 'Error: ' . $e->getMessage();
            $message_type = 'error';
        }
    }
    
    if (isset($_POST['save_email_settings'])) {
        try {
            $email_settings = [
                'smtp_host' => sanitizeInput($_POST['smtp_host'] ?? ''),
                'smtp_port' => sanitizeInput($_POST['smtp_port'] ?? ''),
                'smtp_username' => sanitizeInput($_POST['smtp_username'] ?? ''),
                'smtp_password' => sanitizeInput($_POST['smtp_password'] ?? ''), // In production, encrypt this
                'smtp_encryption' => sanitizeInput($_POST['smtp_encryption'] ?? ''),
                'notification_email' => sanitizeInput($_POST['notification_email'] ?? ''),
            ];
            
            foreach ($email_settings as $key => $value) {
                $stmt = $db->prepare("INSERT INTO business_settings (setting_key, setting_value) VALUES (?, ?) ON DUPLICATE KEY UPDATE setting_value = ?");
                $stmt->execute([$key, $value, $value]);
            }
            
            $message = 'Email settings updated successfully!';
            $message_type = 'success';
        } catch (Exception $e) {
            $message = 'Error: ' . $e->getMessage();
            $message_type = 'error';
        }
    }
}

// Get all settings
try {
    $db = getDB();
    $stmt = $db->query("SELECT setting_key, setting_value FROM business_settings");
    $settings_data = [];
    while ($row = $stmt->fetch()) {
        $settings_data[$row['setting_key']] = $row['setting_value'];
    }
} catch (Exception $e) {
    $settings_data = [];
}

// Helper function to get setting value
function getSetting($key, $default = '') {
    global $settings_data;
    return isset($settings_data[$key]) ? $settings_data[$key] : $default;
}

$page_title = 'Settings Management';
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo $page_title; ?> - Admin Panel</title>
    <link rel="icon" type="image/x-icon" href="../public/favicon.ico">
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        :root {
            --primary-purple: #6B46C1;
            --primary-gold: #B8860B;
            --text-primary: #1F2937;
            --text-secondary: #6B7280;
            --bg-light: #F9FAFB;
            --bg-white: #FFFFFF;
            --border-color: #E5E7EB;
            --success-green: #10B981;
            --warning-yellow: #F59E0B;
            --error-red: #EF4444;
            --info-blue: #3B82F6;
            --shadow-md: 0 4px 6px -1px rgba(0, 0, 0, 0.1);
            --radius-md: 8px;
            --radius-lg: 12px;
            --transition: all 0.3s ease;
        }
        
        * { margin: 0; padding: 0; box-sizing: border-box; }
        
        body {
            font-family: 'Poppins', sans-serif;
            background: var(--bg-light);
            color: var(--text-primary);
            line-height: 1.6;
        }
        
        .admin-layout { display: flex; min-height: 100vh; }
        
        .sidebar {
            width: 280px;
            background: var(--bg-white);
            border-right: 1px solid var(--border-color);
            padding: 2rem 0;
            position: fixed;
            height: 100vh;
            overflow-y: auto;
            box-shadow: 0 1px 2px 0 rgba(0, 0, 0, 0.05);
        }
        
        .sidebar-header {
            padding: 0 2rem 2rem;
            border-bottom: 1px solid var(--border-color);
            margin-bottom: 2rem;
        }
        
        .sidebar-logo {
            display: flex;
            align-items: center;
            gap: 1rem;
        }
        
        .sidebar-logo .logo-icon {
            width: 40px;
            height: 40px;
            background: var(--primary-gold);
            border-radius: 8px;
            display: flex;
            align-items: center;
            justify-content: center;
            color: white;
        }
        
        .sidebar-title {
            font-size: 1.2rem;
            font-weight: 600;
            color: var(--text-primary);
        }
        
        .sidebar-subtitle {
            font-size: 0.8rem;
            color: var(--text-secondary);
        }
        
        .sidebar-nav { padding: 0 1rem; }
        
        .nav-item { margin-bottom: 0.5rem; }
        
        .nav-link {
            display: flex;
            align-items: center;
            gap: 1rem;
            padding: 1rem;
            color: var(--text-secondary);
            text-decoration: none;
            border-radius: var(--radius-md);
            transition: var(--transition);
            font-weight: 500;
        }
        
        .nav-link:hover {
            background: var(--bg-light);
            color: var(--primary-purple);
        }
        
        .nav-link.active {
            background: var(--primary-purple);
            color: white;
        }
        
        .nav-link i { width: 20px; text-align: center; }
        
        .main-content {
            flex: 1;
            margin-left: 280px;
            padding: 2rem;
        }
        
        .page-header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 2rem;
            padding-bottom: 1rem;
            border-bottom: 1px solid var(--border-color);
        }
        
        .page-title {
            font-size: 2rem;
            font-weight: 600;
            color: var(--text-primary);
        }
        
        .admin-info {
            display: flex;
            align-items: center;
            gap: 1rem;
        }
        
        .admin-avatar {
            width: 40px;
            height: 40px;
            background: var(--primary-gold);
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            color: white;
            font-weight: 600;
        }
        
        .admin-details {
            display: flex;
            flex-direction: column;
        }
        
        .admin-name {
            font-weight: 600;
            font-size: 0.9rem;
        }
        
        .admin-role {
            font-size: 0.8rem;
            color: var(--text-secondary);
        }
        
        .logout-btn {
            background: var(--error-red);
            color: white;
            border: none;
            padding: 0.5rem 1rem;
            border-radius: var(--radius-md);
            cursor: pointer;
            font-size: 0.85rem;
            transition: var(--transition);
        }
        
        .logout-btn:hover { background: #DC2626; }
        
        .alert {
            padding: 1rem 1.5rem;
            border-radius: var(--radius-md);
            margin-bottom: 2rem;
            display: flex;
            align-items: center;
            gap: 0.75rem;
        }
        
        .alert-success {
            background: rgba(16, 185, 129, 0.1);
            border: 1px solid rgba(16, 185, 129, 0.2);
            color: var(--success-green);
        }
        
        .alert-error {
            background: rgba(239, 68, 68, 0.1);
            border: 1px solid rgba(239, 68, 68, 0.2);
            color: var(--error-red);
        }
        
        .settings-tabs {
            display: flex;
            gap: 0.5rem;
            margin-bottom: 2rem;
            border-bottom: 1px solid var(--border-color);
        }
        
        .tab-button {
            padding: 1rem 1.5rem;
            border: none;
            background: none;
            color: var(--text-secondary);
            cursor: pointer;
            border-bottom: 2px solid transparent;
            transition: var(--transition);
            font-weight: 500;
            font-size: 0.9rem;
        }
        
        .tab-button:hover {
            color: var(--primary-purple);
        }
        
        .tab-button.active {
            color: var(--primary-purple);
            border-bottom-color: var(--primary-purple);
        }
        
        .tab-content {
            display: none;
        }
        
        .tab-content.active {
            display: block;
        }
        
        .form-section {
            background: var(--bg-white);
            padding: 2rem;
            border-radius: var(--radius-lg);
            box-shadow: var(--shadow-md);
            margin-bottom: 2rem;
        }
        
        .section-title {
            font-size: 1.3rem;
            font-weight: 600;
            color: var(--text-primary);
            margin-bottom: 1.5rem;
            padding-bottom: 0.5rem;
            border-bottom: 2px solid var(--primary-gold);
        }
        
        .form-grid {
            display: grid;
            grid-template-columns: 1fr 1fr;
            gap: 1.5rem;
            margin-bottom: 1.5rem;
        }
        
        .form-group { margin-bottom: 1.5rem; }
        
        .form-group.full-width { grid-column: 1 / -1; }
        
        .form-label {
            display: block;
            font-weight: 500;
            color: var(--text-primary);
            margin-bottom: 0.5rem;
            font-size: 0.9rem;
        }
        
        .form-input {
            width: 100%;
            padding: 0.75rem;
            border: 1px solid var(--border-color);
            border-radius: var(--radius-md);
            font-size: 1rem;
            transition: var(--transition);
        }
        
        .form-input:focus {
            outline: none;
            border-color: var(--primary-purple);
            box-shadow: 0 0 0 3px rgba(107, 70, 193, 0.1);
        }
        
        .form-textarea { min-height: 100px; resize: vertical; }
        
        .btn {
            padding: 0.75rem 1.5rem;
            border: none;
            border-radius: var(--radius-md);
            font-weight: 600;
            cursor: pointer;
            transition: var(--transition);
            text-decoration: none;
            display: inline-flex;
            align-items: center;
            gap: 0.5rem;
        }
        
        .btn-primary { background: var(--primary-purple); color: white; }
        .btn-primary:hover { background: #553C9A; }
        .btn-secondary { background: var(--text-secondary); color: white; }
        .btn-secondary:hover { background: #4B5563; }
        
        .settings-info {
            background: rgba(59, 130, 246, 0.05);
            border: 1px solid rgba(59, 130, 246, 0.2);
            padding: 1rem;
            border-radius: var(--radius-md);
            margin-bottom: 2rem;
            color: var(--info-blue);
        }
        
        .input-help {
            font-size: 0.8rem;
            color: var(--text-secondary);
            margin-top: 0.25rem;
        }
        
        @media (max-width: 768px) {
            .sidebar { width: 100%; height: auto; position: relative; }
            .main-content { margin-left: 0; padding: 1rem; }
            .form-grid { grid-template-columns: 1fr; }
            .page-header { flex-direction: column; gap: 1rem; align-items: flex-start; }
            .settings-tabs { flex-wrap: wrap; }
        }
    </style>
</head>
<body>
    <div class="admin-layout">
        <!-- Sidebar -->
        <div class="sidebar">
            <div class="sidebar-header">
                <div class="sidebar-logo">
                    <div class="logo-icon">
                        <i class="fas fa-crown"></i>
                    </div>
                    <div>
                        <div class="sidebar-title">SSV Admin</div>
                        <div class="sidebar-subtitle">Event Management</div>
                    </div>
                </div>
            </div>
            
            <nav class="sidebar-nav">
                <div class="nav-item">
                    <a href="dashboard.php" class="nav-link">
                        <i class="fas fa-tachometer-alt"></i>
                        Dashboard
                    </a>
                </div>
                <div class="nav-item">
                    <a href="hero-slides.php" class="nav-link">
                        <i class="fas fa-images"></i>
                        Hero Slider
                    </a>
                </div>
                <div class="nav-item">
                    <a href="services.php" class="nav-link">
                        <i class="fas fa-concierge-bell"></i>
                        Services
                    </a>
                </div>
                <div class="nav-item">
                    <a href="gallery.php" class="nav-link">
                        <i class="fas fa-photo-video"></i>
                        Gallery
                    </a>
                </div>
                <div class="nav-item">
                    <a href="testimonials.php" class="nav-link">
                        <i class="fas fa-star"></i>
                        Testimonials
                    </a>
                </div>
                <div class="nav-item">
                    <a href="enquiries.php" class="nav-link">
                        <i class="fas fa-envelope"></i>
                        Enquiries
                    </a>
                </div>
                <div class="nav-item">
                    <a href="settings.php" class="nav-link active">
                        <i class="fas fa-cog"></i>
                        Settings
                    </a>
                </div>
            </nav>
        </div>
        
        <!-- Main Content -->
        <div class="main-content">
            <div class="page-header">
                <h1 class="page-title"><?php echo $page_title; ?></h1>
                <div class="admin-info">
                    <div class="admin-avatar">
                        <?php echo strtoupper(substr($admin['name'], 0, 1)); ?>
                    </div>
                    <div class="admin-details">
                        <div class="admin-name"><?php echo htmlspecialchars($admin['name']); ?></div>
                        <div class="admin-role">Administrator</div>
                    </div>
                    <form method="POST" style="margin-left: 1rem;">
                        <button type="submit" name="logout" class="logout-btn">
                            <i class="fas fa-sign-out-alt"></i> Logout
                        </button>
                    </form>
                </div>
            </div>
            
            <?php if ($message): ?>
                <div class="alert alert-<?php echo $message_type; ?>">
                    <i class="fas fa-<?php echo $message_type === 'success' ? 'check-circle' : 'exclamation-triangle'; ?>"></i>
                    <?php echo htmlspecialchars($message); ?>
                </div>
            <?php endif; ?>
            
            <div class="settings-info">
                <i class="fas fa-info-circle"></i>
                <strong>Important:</strong> These settings control various aspects of your website. Make sure to test changes on a development environment first.
            </div>
            
            <!-- Settings Tabs -->
            <div class="settings-tabs">
                <button class="tab-button active" onclick="showTab('general')">
                    <i class="fas fa-building"></i> General Settings
                </button>
                <button class="tab-button" onclick="showTab('social')">
                    <i class="fas fa-share-alt"></i> Social Media
                </button>
                <button class="tab-button" onclick="showTab('seo')">
                    <i class="fas fa-search"></i> SEO & Analytics
                </button>
                <button class="tab-button" onclick="showTab('email')">
                    <i class="fas fa-envelope"></i> Email Settings
                </button>
            </div>
            
            <!-- General Settings Tab -->
            <div id="general-tab" class="tab-content active">
                <div class="form-section">
                    <h2 class="section-title">General Business Information</h2>
                    
                    <form method="POST">
                        <div class="form-grid">
                            <div class="form-group">
                                <label for="site_name" class="form-label">Site Name</label>
                                <input type="text" id="site_name" name="site_name" class="form-input" 
                                       value="<?php echo htmlspecialchars(getSetting('site_name', 'Shree Shyam Vartika')); ?>">
                                <div class="input-help">The name displayed in browser tabs and search results</div>
                            </div>
                            
                            <div class="form-group">
                                <label for="site_tagline" class="form-label">Site Tagline</label>
                                <input type="text" id="site_tagline" name="site_tagline" class="form-input" 
                                       value="<?php echo htmlspecialchars(getSetting('site_tagline', 'Creating Memorable Events')); ?>">
                                <div class="input-help">Short description of your business</div>
                            </div>
                            
                            <div class="form-group">
                                <label for="business_name" class="form-label">Business Name</label>
                                <input type="text" id="business_name" name="business_name" class="form-input" 
                                       value="<?php echo htmlspecialchars(getSetting('business_name')); ?>">
                            </div>
                            
                            <div class="form-group">
                                <label for="primary_email" class="form-label">Primary Email</label>
                                <input type="email" id="primary_email" name="primary_email" class="form-input" 
                                       value="<?php echo htmlspecialchars(getSetting('primary_email')); ?>">
                            </div>
                            
                            <div class="form-group">
                                <label for="secondary_email" class="form-label">Secondary Email</label>
                                <input type="email" id="secondary_email" name="secondary_email" class="form-input" 
                                       value="<?php echo htmlspecialchars(getSetting('secondary_email')); ?>">
                            </div>
                            
                            <div class="form-group">
                                <label for="primary_phone" class="form-label">Primary Phone</label>
                                <input type="tel" id="primary_phone" name="primary_phone" class="form-input" 
                                       value="<?php echo htmlspecialchars(getSetting('primary_phone')); ?>">
                            </div>
                            
                            <div class="form-group">
                                <label for="secondary_phone" class="form-label">Secondary Phone</label>
                                <input type="tel" id="secondary_phone" name="secondary_phone" class="form-input" 
                                       value="<?php echo htmlspecialchars(getSetting('secondary_phone')); ?>">
                            </div>
                            
                            <div class="form-group">
                                <label for="whatsapp_number" class="form-label">WhatsApp Number</label>
                                <input type="tel" id="whatsapp_number" name="whatsapp_number" class="form-input" 
                                       value="<?php echo htmlspecialchars(getSetting('whatsapp_number')); ?>"
                                       placeholder="+91XXXXXXXXXX">
                                <div class="input-help">Include country code (e.g., +919876543210)</div>
                            </div>
                            
                            <div class="form-group full-width">
                                <label for="business_description" class="form-label">Business Description</label>
                                <textarea id="business_description" name="business_description" class="form-input form-textarea"><?php echo htmlspecialchars(getSetting('business_description')); ?></textarea>
                            </div>
                            
                            <div class="form-group full-width">
                                <label for="business_address" class="form-label">Business Address</label>
                                <textarea id="business_address" name="business_address" class="form-input"><?php echo htmlspecialchars(getSetting('business_address')); ?></textarea>
                            </div>
                            
                            <div class="form-group">
                                <label for="city" class="form-label">City</label>
                                <input type="text" id="city" name="city" class="form-input" 
                                       value="<?php echo htmlspecialchars(getSetting('city')); ?>">
                            </div>
                            
                            <div class="form-group">
                                <label for="state" class="form-label">State</label>
                                <input type="text" id="state" name="state" class="form-input" 
                                       value="<?php echo htmlspecialchars(getSetting('state')); ?>">
                            </div>
                            
                            <div class="form-group">
                                <label for="postal_code" class="form-label">Postal Code</label>
                                <input type="text" id="postal_code" name="postal_code" class="form-input" 
                                       value="<?php echo htmlspecialchars(getSetting('postal_code')); ?>">
                            </div>
                            
                            <div class="form-group">
                                <label for="country" class="form-label">Country</label>
                                <input type="text" id="country" name="country" class="form-input" 
                                       value="<?php echo htmlspecialchars(getSetting('country', 'India')); ?>">
                            </div>
                            
                            <div class="form-group full-width">
                                <label for="business_hours" class="form-label">Business Hours</label>
                                <textarea id="business_hours" name="business_hours" class="form-input" 
                                          placeholder="Mon-Fri: 9:00 AM - 6:00 PM&#10;Sat: 9:00 AM - 4:00 PM&#10;Sun: Closed"><?php echo htmlspecialchars(getSetting('business_hours')); ?></textarea>
                            </div>
                        </div>
                        
                        <button type="submit" name="save_general_settings" class="btn btn-primary">
                            <i class="fas fa-save"></i> Save General Settings
                        </button>
                    </form>
                </div>
            </div>
            
            <!-- Social Media Tab -->
            <div id="social-tab" class="tab-content">
                <div class="form-section">
                    <h2 class="section-title">Social Media Links</h2>
                    
                    <form method="POST">
                        <div class="form-grid">
                            <div class="form-group">
                                <label for="facebook_url" class="form-label">Facebook URL</label>
                                <input type="url" id="facebook_url" name="facebook_url" class="form-input" 
                                       value="<?php echo htmlspecialchars(getSetting('facebook_url')); ?>"
                                       placeholder="https://facebook.com/yourpage">
                            </div>
                            
                            <div class="form-group">
                                <label for="instagram_url" class="form-label">Instagram URL</label>
                                <input type="url" id="instagram_url" name="instagram_url" class="form-input" 
                                       value="<?php echo htmlspecialchars(getSetting('instagram_url')); ?>"
                                       placeholder="https://instagram.com/youraccount">
                            </div>
                            
                            <div class="form-group">
                                <label for="twitter_url" class="form-label">Twitter URL</label>
                                <input type="url" id="twitter_url" name="twitter_url" class="form-input" 
                                       value="<?php echo htmlspecialchars(getSetting('twitter_url')); ?>"
                                       placeholder="https://twitter.com/youraccount">
                            </div>
                            
                            <div class="form-group">
                                <label for="youtube_url" class="form-label">YouTube URL</label>
                                <input type="url" id="youtube_url" name="youtube_url" class="form-input" 
                                       value="<?php echo htmlspecialchars(getSetting('youtube_url')); ?>"
                                       placeholder="https://youtube.com/c/yourchannel">
                            </div>
                            
                            <div class="form-group">
                                <label for="linkedin_url" class="form-label">LinkedIn URL</label>
                                <input type="url" id="linkedin_url" name="linkedin_url" class="form-input" 
                                       value="<?php echo htmlspecialchars(getSetting('linkedin_url')); ?>"
                                       placeholder="https://linkedin.com/company/yourcompany">
                            </div>
                            
                            <div class="form-group">
                                <label for="pinterest_url" class="form-label">Pinterest URL</label>
                                <input type="url" id="pinterest_url" name="pinterest_url" class="form-input" 
                                       value="<?php echo htmlspecialchars(getSetting('pinterest_url')); ?>"
                                       placeholder="https://pinterest.com/youraccount">
                            </div>
                        </div>
                        
                        <button type="submit" name="save_social_settings" class="btn btn-primary">
                            <i class="fas fa-save"></i> Save Social Media Settings
                        </button>
                    </form>
                </div>
            </div>
            
            <!-- SEO & Analytics Tab -->
            <div id="seo-tab" class="tab-content">
                <div class="form-section">
                    <h2 class="section-title">SEO & Analytics Settings</h2>
                    
                    <form method="POST">
                        <div class="form-grid">
                            <div class="form-group full-width">
                                <label for="meta_title" class="form-label">Meta Title</label>
                                <input type="text" id="meta_title" name="meta_title" class="form-input" 
                                       value="<?php echo htmlspecialchars(getSetting('meta_title')); ?>"
                                       maxlength="60">
                                <div class="input-help">Recommended: 50-60 characters</div>
                            </div>
                            
                            <div class="form-group full-width">
                                <label for="meta_description" class="form-label">Meta Description</label>
                                <textarea id="meta_description" name="meta_description" class="form-input" 
                                          maxlength="160"><?php echo htmlspecialchars(getSetting('meta_description')); ?></textarea>
                                <div class="input-help">Recommended: 150-160 characters</div>
                            </div>
                            
                            <div class="form-group full-width">
                                <label for="meta_keywords" class="form-label">Meta Keywords</label>
                                <input type="text" id="meta_keywords" name="meta_keywords" class="form-input" 
                                       value="<?php echo htmlspecialchars(getSetting('meta_keywords')); ?>"
                                       placeholder="event planning, wedding, birthday, corporate events">
                                <div class="input-help">Separate keywords with commas</div>
                            </div>
                            
                            <div class="form-group">
                                <label for="google_analytics_id" class="form-label">Google Analytics ID</label>
                                <input type="text" id="google_analytics_id" name="google_analytics_id" class="form-input" 
                                       value="<?php echo htmlspecialchars(getSetting('google_analytics_id')); ?>"
                                       placeholder="G-XXXXXXXXXX or UA-XXXXXXXXX-X">
                            </div>
                            
                            <div class="form-group full-width">
                                <label for="google_maps_embed" class="form-label">Google Maps Embed Code</label>
                                <textarea id="google_maps_embed" name="google_maps_embed" class="form-input form-textarea"><?php echo htmlspecialchars(getSetting('google_maps_embed')); ?></textarea>
                                <div class="input-help">Paste the complete iframe embed code from Google Maps</div>
                            </div>
                        </div>
                        
                        <button type="submit" name="save_seo_settings" class="btn btn-primary">
                            <i class="fas fa-save"></i> Save SEO & Analytics Settings
                        </button>
                    </form>
                </div>
            </div>
            
            <!-- Email Settings Tab -->
            <div id="email-tab" class="tab-content">
                <div class="form-section">
                    <h2 class="section-title">Email Configuration</h2>
                    
                    <form method="POST">
                        <div class="form-grid">
                            <div class="form-group">
                                <label for="smtp_host" class="form-label">SMTP Host</label>
                                <input type="text" id="smtp_host" name="smtp_host" class="form-input" 
                                       value="<?php echo htmlspecialchars(getSetting('smtp_host')); ?>"
                                       placeholder="smtp.gmail.com">
                            </div>
                            
                            <div class="form-group">
                                <label for="smtp_port" class="form-label">SMTP Port</label>
                                <input type="number" id="smtp_port" name="smtp_port" class="form-input" 
                                       value="<?php echo htmlspecialchars(getSetting('smtp_port', '587')); ?>"
                                       placeholder="587">
                            </div>
                            
                            <div class="form-group">
                                <label for="smtp_username" class="form-label">SMTP Username</label>
                                <input type="text" id="smtp_username" name="smtp_username" class="form-input" 
                                       value="<?php echo htmlspecialchars(getSetting('smtp_username')); ?>"
                                       placeholder="your-email@gmail.com">
                            </div>
                            
                            <div class="form-group">
                                <label for="smtp_password" class="form-label">SMTP Password</label>
                                <input type="password" id="smtp_password" name="smtp_password" class="form-input" 
                                       value="<?php echo htmlspecialchars(getSetting('smtp_password')); ?>"
                                       placeholder="Your email password or app password">
                                <div class="input-help">Use app password for Gmail with 2FA enabled</div>
                            </div>
                            
                            <div class="form-group">
                                <label for="smtp_encryption" class="form-label">SMTP Encryption</label>
                                <select id="smtp_encryption" name="smtp_encryption" class="form-input">
                                    <option value="tls" <?php echo getSetting('smtp_encryption') === 'tls' ? 'selected' : ''; ?>>TLS</option>
                                    <option value="ssl" <?php echo getSetting('smtp_encryption') === 'ssl' ? 'selected' : ''; ?>>SSL</option>
                                    <option value="" <?php echo getSetting('smtp_encryption') === '' ? 'selected' : ''; ?>>None</option>
                                </select>
                            </div>
                            
                            <div class="form-group">
                                <label for="notification_email" class="form-label">Notification Email</label>
                                <input type="email" id="notification_email" name="notification_email" class="form-input" 
                                       value="<?php echo htmlspecialchars(getSetting('notification_email')); ?>"
                                       placeholder="admin@yourdomain.com">
                                <div class="input-help">Email to receive notifications (enquiries, bookings, etc.)</div>
                            </div>
                        </div>
                        
                        <button type="submit" name="save_email_settings" class="btn btn-primary">
                            <i class="fas fa-save"></i> Save Email Settings
                        </button>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <script>
        function showTab(tabName) {
            // Hide all tab contents
            document.querySelectorAll('.tab-content').forEach(content => {
                content.classList.remove('active');
            });
            
            // Remove active class from all tab buttons
            document.querySelectorAll('.tab-button').forEach(button => {
                button.classList.remove('active');
            });
            
            // Show selected tab content
            document.getElementById(tabName + '-tab').classList.add('active');
            
            // Add active class to clicked button
            event.target.closest('.tab-button').classList.add('active');
        }
    </script>
</body>
</html>