<?php
// Page configuration
$page_title = "Home";
$page_description = "Premier event management services for weddings, engagements, birthdays, and corporate events. Creating unforgettable memories with style and elegance.";
$body_class = "home-page";

// Include database connection
require_once '../config/db.php';

// Fetch featured services
$featured_services = [];
try {
    $db = getDB();
    $stmt = $db->prepare("SELECT * FROM services WHERE is_featured = 1 AND is_active = 1 ORDER BY display_order LIMIT 4");
    $stmt->execute();
    $featured_services = $stmt->fetchAll();
} catch(Exception $e) {
    // Handle error silently for now
}

// Fetch featured gallery items
$featured_gallery = [];
try {
    $stmt = $db->prepare("SELECT * FROM gallery WHERE is_featured = 1 ORDER BY display_order LIMIT 6");
    $stmt->execute();
    $featured_gallery = $stmt->fetchAll();
} catch(Exception $e) {
    // Handle error silently for now
}

// Fetch testimonials for home page
$testimonials = [];
try {
    $stmt = $db->prepare("SELECT * FROM testimonials WHERE show_on_home = 1 AND is_approved = 1 ORDER BY display_order LIMIT 4");
    $stmt->execute();
    $testimonials = $stmt->fetchAll();
} catch(Exception $e) {
    // Handle error silently for now
}

// Fetch hero slides
$hero_slides = [];
try {
    $stmt = $db->prepare("SELECT * FROM hero_slides WHERE is_active = 1 ORDER BY display_order LIMIT 5");
    $stmt->execute();
    $hero_slides = $stmt->fetchAll();
} catch(Exception $e) {
    // Handle error silently for now
}

// Calculate average rating
$avg_rating = 4.9;
$total_events = 500;
try {
    $stmt = $db->prepare("SELECT AVG(rating) as avg_rating, COUNT(*) as total_count FROM testimonials WHERE is_approved = 1");
    $stmt->execute();
    $result = $stmt->fetch();
    if ($result && $result['avg_rating']) {
        $avg_rating = round($result['avg_rating'], 1);
        $total_events = $result['total_count'];
    }
} catch(Exception $e) {
    // Use default values
}

// Include header
include '../includes/header.php';
?>

<!-- Hero Section with Swiper -->
<section class="hero" id="hero">
    <div class="hero-slider swiper">
        <div class="swiper-wrapper">
            <?php if (!empty($hero_slides)): ?>
                <!-- Dynamic slides from database -->
                <?php foreach ($hero_slides as $slide): ?>
                <div class="swiper-slide">
                    <div class="hero-background">
                        <img src="assets/images/hero/<?php echo htmlspecialchars($slide['image_file']); ?>" 
                             alt="<?php echo htmlspecialchars($slide['title']); ?>" 
                             data-src="assets/images/hero/<?php echo htmlspecialchars($slide['image_file']); ?>" 
                             class="lazy">
                    </div>
                    <div class="hero-overlay"></div>
                    <div class="hero-content animate-fade-up">
                        <h1 class="hero-title"><?php echo htmlspecialchars($slide['title']); ?></h1>
                        <?php if ($slide['subtitle']): ?>
                        <p class="hero-subtitle script-text"><?php echo htmlspecialchars($slide['subtitle']); ?></p>
                        <?php endif; ?>
                        <?php if ($slide['description']): ?>
                        <p class="hero-description"><?php echo htmlspecialchars($slide['description']); ?></p>
                        <?php endif; ?>
                        <a href="<?php echo htmlspecialchars($slide['button_link']); ?>" class="hero-cta">
                            <i class="fas fa-calendar-alt"></i>
                            <?php echo htmlspecialchars($slide['button_text']); ?>
                        </a>
                    </div>
                </div>
                <?php endforeach; ?>
            <?php else: ?>
                <!-- Default slides if no database data -->
                <div class="swiper-slide">
                    <div class="hero-background">
                        <img src="assets/images/hero-wedding.jpg" alt="Beautiful wedding celebration" 
                             data-src="assets/images/hero-wedding.jpg" class="lazy">
                    </div>
                    <div class="hero-overlay"></div>
                    <div class="hero-content animate-fade-up">
                        <h1 class="hero-title">Shree Shyam Vartika</h1>
                        <p class="hero-subtitle script-text">Making Your Special Day Unforgettable</p>
                        <p class="hero-description">
                            From intimate engagements to grand weddings, from corporate events to birthday celebrations, 
                            we create magical moments with elegance, style, and perfection.
                        </p>
                        <a href="contact.php" class="hero-cta">
                            <i class="fas fa-calendar-alt"></i>
                            Plan Your Event
                        </a>
                    </div>
                </div>
                
                <div class="swiper-slide">
                    <div class="hero-background">
                        <img src="assets/images/hero-wedding-2.jpg" alt="Royal wedding celebration" 
                             data-src="assets/images/hero-wedding-2.jpg" class="lazy">
                    </div>
                    <div class="hero-overlay"></div>
                    <div class="hero-content animate-fade-up">
                        <h1 class="hero-title">Royal Wedding Celebrations</h1>
                        <p class="hero-subtitle script-text">Where Dreams Come True</p>
                        <p class="hero-description">
                            Experience the magic of your perfect wedding with our comprehensive wedding packages. 
                            Every detail crafted to perfection for your special day.
                        </p>
                        <a href="services.php" class="hero-cta">
                            <i class="fas fa-heart"></i>
                            View Wedding Packages
                        </a>
                    </div>
                </div>
                
                <div class="swiper-slide">
                    <div class="hero-background">
                        <img src="assets/images/hero-events.jpg" alt="Elegant event management" 
                             data-src="assets/images/hero-events.jpg" class="lazy">
                    </div>
                    <div class="hero-overlay"></div>
                    <div class="hero-content animate-fade-up">
                        <h1 class="hero-title">Elegant Event Management</h1>
                        <p class="hero-subtitle script-text">Creating Unforgettable Memories</p>
                        <p class="hero-description">
                            From birthdays to corporate events, we bring creativity and professionalism to every celebration. 
                            Let us make your event extraordinary.
                        </p>
                        <a href="services.php" class="hero-cta">
                            <i class="fas fa-concierge-bell"></i>
                            Explore Services
                        </a>
                    </div>
                </div>
            <?php endif; ?>
        </div>
        
        <!-- Swiper Navigation -->
        <div class="swiper-button-next"></div>
        <div class="swiper-button-prev"></div>
        
        <!-- Swiper Pagination -->
        <div class="swiper-pagination"></div>
    </div>
    
    <div class="hero-scroll-indicator">
        <i class="fas fa-chevron-down"></i>
    </div>
</section>

<!-- Featured Services Section -->
<section class="section" id="services-preview">
    <div class="container">
        <div class="section-header animate-fade-up">
            <p class="section-subtitle script-text">Our Specialties</p>
            <h2 class="section-title">Featured Services</h2>
            <p class="section-description">
                We specialize in creating extraordinary experiences for life's most important moments. 
                Each event is crafted with attention to detail and personalized to your vision.
            </p>
        </div>
        
        <div class="grid grid-3">
            <?php if (empty($featured_services)): ?>
                <!-- Default service cards if no data from database -->
                <div class="card service-card glass-card animate-fade-up">
                    <div class="service-icon">
                        <i class="fas fa-heart"></i>
                    </div>
                    <h3 class="service-title">Royal Wedding Package</h3>
                    <p class="service-description">
                        Complete wedding arrangement with decoration, catering, photography, and entertainment. 
                        Create your perfect day with our comprehensive wedding solutions.
                    </p>
                    <ul class="service-features">
                        <li><i class="fas fa-check"></i> Mandap & Stage Decoration</li>
                        <li><i class="fas fa-check"></i> Catering & Cuisine</li>
                        <li><i class="fas fa-check"></i> Photography & Videography</li>
                        <li><i class="fas fa-check"></i> Music & Entertainment</li>
                    </ul>
                    <div class="service-price">
                        <span class="price-label">Starting from</span>
                        <div class="price-value">₹899/plate</div>
                    </div>
                    <a href="services.php" class="btn btn-primary">Learn More</a>
                </div>
                
                <div class="card service-card glass-card animate-fade-up">
                    <div class="service-icon">
                        <i class="fas fa-ring"></i>
                    </div>
                    <h3 class="service-title">Elegant Engagement</h3>
                    <p class="service-description">
                        Beautiful engagement setup with floral arrangements, stage decoration, and catering services. 
                        Perfect for intimate engagement celebrations.
                    </p>
                    <ul class="service-features">
                        <li><i class="fas fa-check"></i> Floral Arrangements</li>
                        <li><i class="fas fa-check"></i> Stage Decoration</li>
                        <li><i class="fas fa-check"></i> Catering Services</li>
                        <li><i class="fas fa-check"></i> Photography</li>
                    </ul>
                    <div class="service-price">
                        <span class="price-label">Starting from</span>
                        <div class="price-value">₹699/plate</div>
                    </div>
                    <a href="services.php" class="btn btn-primary">Learn More</a>
                </div>
                
                <div class="card service-card glass-card animate-fade-up">
                    <div class="service-icon">
                        <i class="fas fa-glass-cheers"></i>
                    </div>
                    <h3 class="service-title">Grand Reception</h3>
                    <p class="service-description">
                        Luxurious reception arrangement with premium decoration, multi-cuisine catering, 
                        and live entertainment for unforgettable celebrations.
                    </p>
                    <ul class="service-features">
                        <li><i class="fas fa-check"></i> Premium Decoration</li>
                        <li><i class="fas fa-check"></i> Multi-cuisine Catering</li>
                        <li><i class="fas fa-check"></i> Live Entertainment</li>
                        <li><i class="fas fa-check"></i> Dance Floor</li>
                    </ul>
                    <div class="service-price">
                        <span class="price-label">Starting from</span>
                        <div class="price-value">₹999/plate</div>
                    </div>
                    <a href="services.php" class="btn btn-primary">Learn More</a>
                </div>
            <?php else: ?>
                <!-- Dynamic service cards from database -->
                <?php foreach ($featured_services as $service): ?>
                <div class="card service-card glass-card animate-fade-up">
                    <div class="service-icon">
                        <i class="fas fa-star"></i>
                    </div>
                    <h3 class="service-title"><?php echo htmlspecialchars($service['title']); ?></h3>
                    <p class="service-description">
                        <?php echo htmlspecialchars($service['short_description'] ?: $service['description']); ?>
                    </p>
                    <?php if ($service['capacity'] || $service['per_plate_charge']): ?>
                    <div class="service-features">
                        <?php if ($service['capacity']): ?>
                        <div class="feature-item">
                            <i class="fas fa-users"></i>
                            <span>Up to <?php echo $service['capacity']; ?> guests</span>
                        </div>
                        <?php endif; ?>
                    </div>
                    <?php endif; ?>
                    <?php if ($service['per_plate_charge']): ?>
                    <div class="service-price">
                        <span class="price-label">Starting from</span>
                        <div class="price-value">₹<?php echo number_format($service['per_plate_charge'], 0); ?>/plate</div>
                    </div>
                    <?php endif; ?>
                    <a href="services.php" class="btn btn-primary">Learn More</a>
                </div>
                <?php endforeach; ?>
            <?php endif; ?>
        </div>
        
        <div class="text-center" style="margin-top: 3rem;">
            <a href="services.php" class="btn btn-outline btn-lg">
                <i class="fas fa-concierge-bell"></i>
                View All Services
            </a>
        </div>
    </div>
</section>

<!-- Gallery Preview Section -->
<section class="section" id="gallery-preview" style="background: linear-gradient(135deg, #F9FAFB 0%, #F3F4F6 100%);">
    <div class="container">
        <div class="section-header animate-fade-up">
            <p class="section-subtitle script-text">Our Work</p>
            <h2 class="section-title">Event Gallery</h2>
            <p class="section-description">
                Take a look at some of our recent events and celebrations. Each moment captured 
                showcases our commitment to creating beautiful, memorable experiences.
            </p>
        </div>
        
        <div class="gallery-grid">
            <?php if (empty($featured_gallery)): ?>
                <!-- Default gallery items -->
                <div class="gallery-item animate-fade-up" data-category="wedding">
                    <img src="assets/images/gallery/wedding-1.jpg" alt="Beautiful wedding decoration" 
                         data-src="assets/images/gallery/wedding-1.jpg" class="lazy">
                    <div class="gallery-overlay">
                        <i class="fas fa-search-plus"></i>
                    </div>
                </div>
                <div class="gallery-item animate-fade-up" data-category="engagement">
                    <img src="assets/images/gallery/engagement-1.jpg" alt="Elegant engagement setup" 
                         data-src="assets/images/gallery/engagement-1.jpg" class="lazy">
                    <div class="gallery-overlay">
                        <i class="fas fa-search-plus"></i>
                    </div>
                </div>
                <div class="gallery-item animate-fade-up" data-category="reception">
                    <img src="assets/images/gallery/reception-1.jpg" alt="Grand reception party" 
                         data-src="assets/images/gallery/reception-1.jpg" class="lazy">
                    <div class="gallery-overlay">
                        <i class="fas fa-search-plus"></i>
                    </div>
                </div>
                <div class="gallery-item animate-fade-up" data-category="birthday">
                    <img src="assets/images/gallery/birthday-1.jpg" alt="Fun birthday celebration" 
                         data-src="assets/images/gallery/birthday-1.jpg" class="lazy">
                    <div class="gallery-overlay">
                        <i class="fas fa-search-plus"></i>
                    </div>
                </div>
                <div class="gallery-item animate-fade-up" data-category="corporate">
                    <img src="assets/images/gallery/corporate-1.jpg" alt="Professional corporate event" 
                         data-src="assets/images/gallery/corporate-1.jpg" class="lazy">
                    <div class="gallery-overlay">
                        <i class="fas fa-search-plus"></i>
                    </div>
                </div>
                <div class="gallery-item animate-fade-up" data-category="wedding">
                    <img src="assets/images/gallery/wedding-2.jpg" alt="Wedding ceremony decoration" 
                         data-src="assets/images/gallery/wedding-2.jpg" class="lazy">
                    <div class="gallery-overlay">
                        <i class="fas fa-search-plus"></i>
                    </div>
                </div>
            <?php else: ?>
                <!-- Dynamic gallery items from database -->
                <?php foreach ($featured_gallery as $item): ?>
                <div class="gallery-item animate-fade-up" 
                     data-category="<?php echo htmlspecialchars($item['service_category']); ?>"
                     data-caption="<?php echo htmlspecialchars($item['title']); ?>">
                    <?php if ($item['file_type'] === 'image'): ?>
                    <img src="<?php echo '../uploads/gallery/' . htmlspecialchars($item['file_name']); ?>" 
                         alt="<?php echo htmlspecialchars($item['alt_text'] ?: $item['title']); ?>"
                         data-src="<?php echo '../uploads/gallery/' . htmlspecialchars($item['file_name']); ?>" 
                         class="lazy">
                    <?php else: ?>
                    <video src="<?php echo '../uploads/gallery/' . htmlspecialchars($item['file_name']); ?>" 
                           title="<?php echo htmlspecialchars($item['title']); ?>" muted>
                    </video>
                    <?php endif; ?>
                    <div class="gallery-overlay">
                        <i class="fas fa-<?php echo $item['file_type'] === 'video' ? 'play' : 'search-plus'; ?>"></i>
                    </div>
                </div>
                <?php endforeach; ?>
            <?php endif; ?>
        </div>
        
        <div class="text-center" style="margin-top: 3rem;">
            <a href="gallery.php" class="btn btn-secondary btn-lg">
                <i class="fas fa-images"></i>
                View Full Gallery
            </a>
        </div>
    </div>
</section>

<!-- Testimonials & Rating Section -->
<section class="section" id="testimonials">
    <div class="container">
        <div class="section-header animate-fade-up">
            <p class="section-subtitle script-text">What Our Clients Say</p>
            <h2 class="section-title">Happy Customers</h2>
            
            <!-- Star Rating Display -->
            <div class="rating-display" style="margin: 2rem 0;">
                <div class="stars" style="justify-content: center; font-size: 1.5rem;">
                    <?php for ($i = 1; $i <= 5; $i++): ?>
                        <i class="fas fa-star" style="color: #F59E0B;"></i>
                    <?php endfor; ?>
                </div>
                <p class="rating-text" style="font-size: 1.2rem; margin-top: 0.5rem;">
                    <strong><?php echo $avg_rating; ?>/5</strong> - Based on <?php echo $total_events; ?>+ events
                </p>
            </div>
        </div>
        
        <div class="grid grid-2">
            <?php if (empty($testimonials)): ?>
                <!-- Default testimonials -->
                <div class="card glass-card animate-fade-left" style="padding: 2rem;">
                    <div class="testimonial-content">
                        <div class="stars" style="margin-bottom: 1rem;">
                            <i class="fas fa-star"></i>
                            <i class="fas fa-star"></i>
                            <i class="fas fa-star"></i>
                            <i class="fas fa-star"></i>
                            <i class="fas fa-star"></i>
                        </div>
                        <p style="font-style: italic; margin-bottom: 1.5rem;">
                            "SSV made our wedding day absolutely perfect! The decoration was stunning and the coordination was flawless. 
                            Highly recommended for anyone planning their special day."
                        </p>
                        <div class="testimonial-author">
                            <strong>Rahul & Priya Sharma</strong>
                            <span style="color: var(--text-muted);">Wedding</span>
                        </div>
                    </div>
                </div>
                
                <div class="card glass-card animate-fade-right" style="padding: 2rem;">
                    <div class="testimonial-content">
                        <div class="stars" style="margin-bottom: 1rem;">
                            <i class="fas fa-star"></i>
                            <i class="fas fa-star"></i>
                            <i class="fas fa-star"></i>
                            <i class="fas fa-star"></i>
                            <i class="fas fa-star"></i>
                        </div>
                        <p style="font-style: italic; margin-bottom: 1.5rem;">
                            "Organized my daughter's engagement ceremony beautifully. The team was professional and attentive to every detail. 
                            Everyone praised the arrangements!"
                        </p>
                        <div class="testimonial-author">
                            <strong>Amit Patel</strong>
                            <span style="color: var(--text-muted);">Engagement</span>
                        </div>
                    </div>
                </div>
                
                <div class="card glass-card animate-fade-left" style="padding: 2rem;">
                    <div class="testimonial-content">
                        <div class="stars" style="margin-bottom: 1rem;">
                            <i class="fas fa-star"></i>
                            <i class="fas fa-star"></i>
                            <i class="fas fa-star"></i>
                            <i class="fas fa-star"></i>
                            <i class="fas fa-star"></i>
                        </div>
                        <p style="font-style: italic; margin-bottom: 1.5rem;">
                            "Best birthday party ever! My son was so happy with the superhero theme decoration. 
                            The entertainment kept all kids engaged throughout the event."
                        </p>
                        <div class="testimonial-author">
                            <strong>Ravi Kumar</strong>
                            <span style="color: var(--text-muted);">Birthday</span>
                        </div>
                    </div>
                </div>
                
                <div class="card glass-card animate-fade-right" style="padding: 2rem;">
                    <div class="testimonial-content">
                        <div class="stars" style="margin-bottom: 1rem;">
                            <i class="fas fa-star"></i>
                            <i class="fas fa-star"></i>
                            <i class="fas fa-star"></i>
                            <i class="fas fa-star"></i>
                            <i class="far fa-star"></i>
                        </div>
                        <p style="font-style: italic; margin-bottom: 1.5rem;">
                            "Excellent corporate event management. They handled our annual conference with 300+ attendees seamlessly. 
                            Great food and perfect arrangements."
                        </p>
                        <div class="testimonial-author">
                            <strong>Sunita Enterprises</strong>
                            <span style="color: var(--text-muted);">Corporate</span>
                        </div>
                    </div>
                </div>
            <?php else: ?>
                <!-- Dynamic testimonials from database -->
                <?php foreach ($testimonials as $index => $testimonial): ?>
                <div class="card glass-card animate-fade-<?php echo $index % 2 === 0 ? 'left' : 'right'; ?>" style="padding: 2rem;">
                    <div class="testimonial-content">
                        <div class="stars" style="margin-bottom: 1rem;">
                            <?php for ($i = 1; $i <= 5; $i++): ?>
                                <i class="fas fa-<?php echo $i <= $testimonial['rating'] ? 'star' : 'star-o'; ?>"></i>
                            <?php endfor; ?>
                        </div>
                        <p style="font-style: italic; margin-bottom: 1.5rem;">
                            "<?php echo htmlspecialchars($testimonial['feedback']); ?>"
                        </p>
                        <div class="testimonial-author">
                            <strong><?php echo htmlspecialchars($testimonial['client_name']); ?></strong>
                            <?php if ($testimonial['event_type']): ?>
                            <span style="color: var(--text-muted);"><?php echo htmlspecialchars($testimonial['event_type']); ?></span>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
                <?php endforeach; ?>
            <?php endif; ?>
        </div>
    </div>
</section>

<!-- About Preview Section -->
<section class="section" id="about-preview" style="background: var(--bg-gradient); color: white;">
    <div class="container">
        <div class="grid grid-2" style="align-items: center; gap: 4rem;">
            <div class="animate-fade-left">
                <p class="section-subtitle script-text" style="color: var(--light-gold);">About Us</p>
                <h2 class="section-title" style="color: white;">Creating Magical Moments Since 2015</h2>
                <p style="font-size: 1.1rem; line-height: 1.8; margin-bottom: 2rem; color: rgba(255,255,255,0.9);">
                    We are passionate about turning your dreams into reality. With over 8 years of experience in event management, 
                    we have successfully organized more than 500 weddings, engagements, birthdays, and corporate events.
                </p>
                <p style="font-size: 1.1rem; line-height: 1.8; margin-bottom: 2rem; color: rgba(255,255,255,0.9);">
                    Our team of creative professionals works tirelessly to ensure every detail is perfect, 
                    creating unforgettable memories that you'll cherish for a lifetime.
                </p>
                <div class="stats" style="display: flex; gap: 2rem; margin-bottom: 2rem;">
                    <div class="stat-item text-center">
                        <div style="font-size: 2rem; font-weight: bold; color: var(--accent-gold);">500+</div>
                        <div style="font-size: 0.9rem;">Events Organized</div>
                    </div>
                    <div class="stat-item text-center">
                        <div style="font-size: 2rem; font-weight: bold; color: var(--accent-gold);">8+</div>
                        <div style="font-size: 0.9rem;">Years Experience</div>
                    </div>
                    <div class="stat-item text-center">
                        <div style="font-size: 2rem; font-weight: bold; color: var(--accent-gold);">4.9</div>
                        <div style="font-size: 0.9rem;">Average Rating</div>
                    </div>
                </div>
                <a href="about.php" class="btn btn-secondary btn-lg">
                    <i class="fas fa-info-circle"></i>
                    Learn More About Us
                </a>
            </div>
            
            <div class="animate-fade-right">
                <img src="assets/images/about-team.jpg" alt="Our professional event management team" 
                     data-src="assets/images/about-team.jpg" 
                     class="lazy" 
                     style="width: 100%; border-radius: 16px; box-shadow: 0 20px 40px rgba(0,0,0,0.3);">
            </div>
        </div>
    </div>
</section>

<!-- Call to Action Section -->
<section class="section" id="cta" style="background: var(--bg-secondary);">
    <div class="container">
        <div class="text-center animate-fade-up">
            <h2 class="section-title">Ready to Plan Your Perfect Event?</h2>
            <p class="section-description" style="font-size: 1.2rem; margin-bottom: 2rem;">
                Let's discuss your vision and create something extraordinary together. 
                Contact us today for a free consultation.
            </p>
            <div class="cta-buttons" style="display: flex; justify-content: center; gap: 1rem; flex-wrap: wrap;">
                <a href="contact.php" class="btn btn-primary btn-lg">
                    <i class="fas fa-envelope"></i>
                    Get Free Quote
                </a>
                <a href="tel:+919876543210" class="btn btn-secondary btn-lg">
                    <i class="fas fa-phone"></i>
                    Call Us Now
                </a>
                <a href="https://wa.me/919876543210?text=Hi%20Shree%20Shyam%20Vartika,%20I%20would%20like%20to%20inquire%20about%20your%20event%20services." 
                   target="_blank" class="btn btn-outline btn-lg" style="border-color: #25D366; color: #25D366;">
                    <i class="fab fa-whatsapp"></i>
                    WhatsApp Us
                </a>
            </div>
        </div>
    </div>
</section>

<style>
/* Custom styles for home page */
.text-center { text-align: center; }

/* Hero Slider Styles */
.hero-slider {
    position: relative;
    width: 100%;
    height: 100%;
}

.hero-slider .swiper-slide {
    position: relative;
    display: flex;
    align-items: center;
    justify-content: center;
}

/* Swiper Navigation Buttons */
.hero-slider .swiper-button-next,
.hero-slider .swiper-button-prev {
    width: 50px;
    height: 50px;
    margin-top: -25px;
    background: rgba(255, 255, 255, 0.1);
    backdrop-filter: blur(10px);
    border: 1px solid rgba(255, 255, 255, 0.2);
    border-radius: 50%;
    color: white;
    font-size: 18px;
    transition: all 0.3s ease;
    opacity: 0;
    transform: scale(0.8);
}

.hero:hover .swiper-button-next,
.hero:hover .swiper-button-prev {
    opacity: 1;
    transform: scale(1);
}

.hero-slider .swiper-button-next:hover,
.hero-slider .swiper-button-prev:hover {
    background: rgba(184, 134, 11, 0.8);
    border-color: var(--primary-gold);
    transform: scale(1.1);
}

.hero-slider .swiper-button-next:after,
.hero-slider .swiper-button-prev:after {
    font-size: 16px;
    font-weight: 600;
}

/* Swiper Pagination */
.hero-slider .swiper-pagination {
    bottom: 30px;
}

.hero-slider .swiper-pagination-bullet {
    width: 12px;
    height: 12px;
    background: rgba(255, 255, 255, 0.5);
    border: 2px solid transparent;
    opacity: 1;
    transition: all 0.3s ease;
}

.hero-slider .swiper-pagination-bullet-active {
    background: var(--primary-gold);
    border-color: white;
    transform: scale(1.2);
}

/* Slide Content Animation */
.swiper-slide .hero-content {
    opacity: 0;
    transform: translateY(50px);
    transition: all 0.8s ease 0.3s;
}

.swiper-slide-active .hero-content {
    opacity: 1;
    transform: translateY(0);
}

.swiper-slide .hero-title {
    transform: translateX(-50px);
    transition: all 0.8s ease 0.5s;
}

.swiper-slide-active .hero-title {
    transform: translateX(0);
}

.swiper-slide .hero-subtitle {
    transform: translateX(50px);
    transition: all 0.8s ease 0.7s;
}

.swiper-slide-active .hero-subtitle {
    transform: translateX(0);
}

.swiper-slide .hero-description {
    opacity: 0;
    transition: all 0.8s ease 0.9s;
}

.swiper-slide-active .hero-description {
    opacity: 1;
}

.swiper-slide .hero-cta {
    opacity: 0;
    transform: translateY(30px);
    transition: all 0.8s ease 1.1s;
}

.swiper-slide-active .hero-cta {
    opacity: 1;
    transform: translateY(0);
}

/* Other home page styles */
.stats {
    display: grid;
    grid-template-columns: repeat(3, 1fr);
    gap: 2rem;
    text-align: center;
}

.cta-buttons {
    display: flex;
    justify-content: center;
    gap: 1rem;
    flex-wrap: wrap;
}

.rating-display {
    text-align: center;
    margin: 2rem 0;
}

.rating-display .stars {
    display: flex;
    justify-content: center;
    gap: 4px;
    margin-bottom: 0.5rem;
}

.testimonial-author {
    display: flex;
    flex-direction: column;
    gap: 0.25rem;
}

.feature-item {
    display: flex;
    align-items: center;
    gap: 0.5rem;
    margin-bottom: 0.5rem;
    font-size: 0.9rem;
    color: var(--text-secondary);
}

.feature-item i {
    color: var(--primary-gold);
    font-size: 0.8rem;
}

@media (max-width: 768px) {
    .hero-slider .swiper-button-next,
    .hero-slider .swiper-button-prev {
        display: none;
    }
    
    .stats {
        grid-template-columns: repeat(3, 1fr);
        gap: 1rem;
        font-size: 0.9rem;
    }
    
    .cta-buttons {
        flex-direction: column;
        align-items: center;
    }
    
    .cta-buttons .btn {
        width: 100%;
        max-width: 300px;
    }
}
</style>

<script>
// Initialize Hero Slider
document.addEventListener('DOMContentLoaded', function() {
    // Initialize Swiper for hero slider
    const heroSwiper = new Swiper('.hero-slider', {
        // Enable autoplay with 3 second delay
        autoplay: {
            delay: 3000,
            disableOnInteraction: false,
            pauseOnMouseEnter: true
        },
        
        // Enable loop
        loop: true,
        
        // Transition effect
        effect: 'fade',
        fadeEffect: {
            crossFade: true
        },
        
        // Speed of transition
        speed: 1000,
        
        // Enable navigation
        navigation: {
            nextEl: '.swiper-button-next',
            prevEl: '.swiper-button-prev'
        },
        
        // Enable pagination
        pagination: {
            el: '.swiper-pagination',
            clickable: true,
            dynamicBullets: true
        },
        
        // Responsive breakpoints
        breakpoints: {
            320: {
                autoplay: {
                    delay: 4000
                }
            },
            768: {
                autoplay: {
                    delay: 3000
                }
            }
        },
        
        // Event callbacks
        on: {
            init: function() {
                // Add loaded class to first slide
                this.slides[this.activeIndex].classList.add('slide-loaded');
            },
            slideChange: function() {
                // Remove loaded class from all slides
                this.slides.forEach(slide => slide.classList.remove('slide-loaded'));
                // Add loaded class to active slide
                this.slides[this.activeIndex].classList.add('slide-loaded');
            }
        }
    });
    
    // Pause autoplay when tab is not visible
    document.addEventListener('visibilitychange', function() {
        if (document.hidden) {
            heroSwiper.autoplay.stop();
        } else {
            heroSwiper.autoplay.start();
        }
    });
});
</script>

<?php include '../includes/footer.php'; ?>